/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.tables;

import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWInvokeInstruction;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWPartnerLinkDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.VWWebServiceUtils;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.workflow.VWBaseFieldTableModel;
import filenet.vw.toolkit.design.property.workflow.VWTableItemWrapper;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.ws.api.WSOperation;
import filenet.ws.api.WSWSDLRefs;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;

public class VWPartnerLinksTableModel
extends VWBaseFieldTableModel {
    private static final int NUM_COLUMNS = 3;
    public static final int COL_SOURCE = 0;
    public static final int COL_NAME = 1;
    public static final int COL_TYPE = 2;
    public static final int COL_END_POINT = 3;
    public static final int COL_PORT_TYPE = 4;
    public static final int COL_ROLE = 5;
    public static final int COL_PROCESS_PORT_TYPE = 6;
    public static final int COL_PROCESS_ROLE = 7;
    private JComponent m_uiContainer = null;
    private String m_tempEndPoint = null;
    private String m_tempPortType = null;
    private String m_tempRole = null;
    private String m_tempProcessPortType = null;
    private String m_tempProcessRole = null;

    public VWPartnerLinksTableModel(VWAuthPropertyData authPropertyData, JComponent uiContainer) {
        super(authPropertyData);
        this.m_uiContainer = uiContainer;
    }

    public void deleteItem(int nRowIndex) {
        block6: {
            try {
                VWPartnerLinkDefinition partnerLink;
                if (!this.canDeleteRow(nRowIndex)) {
                    return;
                }
                VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                if (wrapper != null && wrapper.canDelete() && (partnerLink = (VWPartnerLinkDefinition)wrapper.getValue()) != null) {
                    this.m_authPropertyData.getWorkflowDefinition().deletePartnerLink(partnerLink.getName());
                    this.m_authPropertyData.resetPartnerLinkCache();
                    this.m_authPropertyData.setDirty();
                    if (wrapper.isOverridden()) {
                        wrapper.deleteOverriddenValue();
                        this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                    } else {
                        this.m_rowData.removeElementAt(nRowIndex);
                        this.fireTableRowsDeleted(nRowIndex, nRowIndex);
                        this.m_changedItems = new Vector();
                        this.m_changedItems.addElement(partnerLink);
                        this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 528);
                    }
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_authPropertyData == null) break block6;
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
            }
        }
    }

    public void copyItem(int nRowIndex) {
        block4: {
            try {
                VWPartnerLinkDefinition partnerLink;
                VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                if (wrapper == null || (partnerLink = (VWPartnerLinkDefinition)wrapper.getValue()) == null) break block4;
                String newName = VWResource.s_copyOfFieldName.toString(partnerLink.getName());
                VWPartnerLinkDefinition newPartnerLink = this.m_authPropertyData.getWorkflowDefinition().createPartnerLink(newName);
                if (newPartnerLink == null) break block4;
                this.m_authPropertyData.resetPartnerLinkCache();
                this.m_authPropertyData.setDirty();
                try {
                    newPartnerLink.setPartnerEndPoint(partnerLink.getPartnerEndPoint());
                    newPartnerLink.setPartnerPortType(partnerLink.getPartnerPortType());
                    newPartnerLink.setPartnerRole(partnerLink.getPartnerRole());
                    newPartnerLink.setMyPortType(partnerLink.getMyPortType());
                    newPartnerLink.setMyRole(partnerLink.getMyRole());
                    newPartnerLink.setPartnerLinkRef(partnerLink.getPartnerLinkRef());
                    newPartnerLink.setWSDLRef(partnerLink.getWSDLRef());
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                }
                this.m_rowData.addElement(new VWTableItemWrapper(0, newPartnerLink));
                nRowIndex = this.getRowCount() - 2;
                this.fireTableRowsInserted(nRowIndex, nRowIndex);
                this.m_changedItems = new Vector();
                this.m_changedItems.addElement(newPartnerLink);
                this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 526);
            }
            catch (Exception ex) {
                if (this.m_authPropertyData == null) break block4;
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reinitialize() {
        try {
            try {
                super.reinitialize();
                this.m_tempEndPoint = null;
                this.m_tempPortType = null;
                this.m_tempRole = null;
                this.m_tempProcessPortType = null;
                this.m_tempProcessRole = null;
                if (this.m_authPropertyData != null) {
                    int i;
                    VWPartnerLinkDefinition[] partnerLinkDefs;
                    if (this.m_authPropertyData.getShowInheritedProperties() && (partnerLinkDefs = this.m_authPropertyData.getPartnerLinks(2)) != null) {
                        for (i = 0; i < partnerLinkDefs.length; ++i) {
                            this.m_rowData.addElement(new VWTableItemWrapper(1, partnerLinkDefs[i]));
                        }
                    }
                    if ((partnerLinkDefs = this.m_authPropertyData.getPartnerLinks(1)) != null) {
                        for (i = 0; i < partnerLinkDefs.length; ++i) {
                            int nIndex = this.findIndex(partnerLinkDefs[i].getName());
                            if (nIndex != -1) {
                                this.overrideTableItem(nIndex, partnerLinkDefs[i]);
                                continue;
                            }
                            this.m_rowData.addElement(new VWTableItemWrapper(0, partnerLinkDefs[i]));
                        }
                    }
                }
                Object var5_5 = null;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var5_6 = null;
                this.fireTableDataChanged();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.fireTableDataChanged();
            throw throwable;
        }
        this.fireTableDataChanged();
    }

    public int findIndex(String fieldName) {
        int nRowIndex = -1;
        int size = this.m_rowData.size();
        if (size > 0 && fieldName != null && fieldName.length() > 0) {
            for (int i = 0; i < size; ++i) {
                String name;
                VWPartnerLinkDefinition partnerLinkDef;
                VWTableItemWrapper wrapper = this.getTableItemAt(i);
                if (wrapper == null || wrapper.getValue() == null || (partnerLinkDef = (VWPartnerLinkDefinition)wrapper.getValue()) == null || VWStringUtils.compare(fieldName, name = partnerLinkDef.getName()) != 0) continue;
                nRowIndex = i;
                break;
            }
        }
        return nRowIndex;
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex + this.m_nColumnIndexOffset) {
            case 0: {
                return Icon.class;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return String.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 3 - this.m_nColumnIndexOffset;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex + this.m_nColumnIndexOffset) {
            case 1: {
                return VWResource.s_nameStr;
            }
            case 2: {
                return VWResource.s_typeStr;
            }
            case 3: {
                return VWResource.s_wsdlURL;
            }
            case 4: {
                return VWResource.s_portType;
            }
            case 5: {
                return VWResource.s_role;
            }
            case 6: {
                return VWResource.s_processPortType;
            }
            case 7: {
                return VWResource.s_processRole;
            }
        }
        return null;
    }

    public int getRowCount() {
        if (this.m_rowData != null) {
            return this.m_rowData.size() + 1;
        }
        return 0;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        VWPartnerLinkDefinition partnerLink = null;
        try {
            VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
            if (wrapper != null) {
                partnerLink = (VWPartnerLinkDefinition)wrapper.getValue();
            }
            switch (nColumnIndex + this.m_nColumnIndexOffset) {
                case 0: {
                    if (wrapper == null) break;
                    return wrapper.getStateIcon();
                }
                case 1: {
                    if (partnerLink == null) break;
                    return partnerLink.getName();
                }
                case 2: {
                    return this.getType(partnerLink);
                }
                case 3: {
                    if (partnerLink != null) {
                        return partnerLink.getPartnerEndPoint();
                    }
                    return this.m_tempEndPoint;
                }
                case 4: {
                    if (partnerLink != null) {
                        return partnerLink.getPartnerPortType();
                    }
                    return this.m_tempPortType;
                }
                case 5: {
                    if (partnerLink != null) {
                        return partnerLink.getPartnerRole();
                    }
                    return this.m_tempRole;
                }
                case 6: {
                    if (partnerLink != null) {
                        return partnerLink.getMyPortType();
                    }
                    return this.m_tempProcessPortType;
                }
                case 7: {
                    if (partnerLink != null) {
                        return partnerLink.getMyRole();
                    }
                    return this.m_tempProcessRole;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex + this.m_nColumnIndexOffset) {
            case 2: {
                return false;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                if (wrapper != null) {
                    return wrapper.isLocal();
                }
                return true;
            }
        }
        return false;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        try {
            if (!this.isCellEditable(nRowIndex, nColumnIndex)) {
                return;
            }
            switch (nColumnIndex + this.m_nColumnIndexOffset) {
                case 1: {
                    this.updateName(nRowIndex, aValue);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    this.updateEndPoint(nRowIndex, aValue);
                    break;
                }
                case 4: {
                    this.updatePortType(nRowIndex, aValue);
                    break;
                }
                case 5: {
                    this.updateRole(nRowIndex, aValue);
                    break;
                }
                case 6: {
                    this.updateProcessPortType(nRowIndex, aValue);
                    break;
                }
                case 7: {
                    this.updateProcessRole(nRowIndex, aValue);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private String getType(VWPartnerLinkDefinition partnerLinkDef) {
        String type = VWResource.s_unknown;
        String wsdlUrl = null;
        String processPortType = null;
        String processRole = null;
        if (partnerLinkDef != null) {
            wsdlUrl = partnerLinkDef.getPartnerEndPoint();
            processPortType = partnerLinkDef.getMyPortType();
            processRole = partnerLinkDef.getMyRole();
        } else {
            wsdlUrl = this.m_tempEndPoint;
            processPortType = this.m_tempProcessPortType;
            processRole = this.m_tempProcessRole;
        }
        if (wsdlUrl == null && processPortType != null && processRole != null) {
            type = VWResource.s_receiveReply;
        } else if (wsdlUrl != null && processPortType == null && processRole == null) {
            type = VWResource.s_invoke;
        } else if (wsdlUrl != null && processPortType != null && processRole != null) {
            type = VWResource.s_both;
        }
        return type;
    }

    private void updateName(int nRowIndex, Object aValue) {
        block9: {
            try {
                if (aValue != null && aValue instanceof String) {
                    String newName = (String)aValue;
                    if (newName.length() == 0) {
                        return;
                    }
                    VWPartnerLinkDefinition partnerLink = null;
                    VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                    if (wrapper != null) {
                        partnerLink = (VWPartnerLinkDefinition)wrapper.getValue();
                    }
                    if (partnerLink != null) {
                        String oldName = partnerLink.getName();
                        partnerLink.setName(newName);
                        this.m_authPropertyData.setDirty();
                        this.fireTableCellUpdated(nRowIndex, 1);
                        this.m_changedItems = new Vector();
                        this.m_changedItems.addElement(oldName);
                        this.m_changedItems.addElement(newName);
                        this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 527);
                    } else {
                        if (this.m_authPropertyData.getPartnerLink(newName) != null) {
                            String message = VWResource.s_partnerLinkExists.toString(newName);
                            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), message, 1);
                            return;
                        }
                        partnerLink = this.m_authPropertyData.getWorkflowDefinition().createPartnerLink(newName);
                        if (partnerLink != null) {
                            partnerLink.setPartnerEndPoint(this.m_tempEndPoint);
                            partnerLink.setPartnerPortType(this.m_tempPortType);
                            partnerLink.setPartnerRole(this.m_tempRole);
                            partnerLink.setMyPortType(this.m_tempProcessPortType);
                            partnerLink.setMyRole(this.m_tempProcessRole);
                            this.m_rowData.addElement(new VWTableItemWrapper(0, partnerLink));
                            this.m_authPropertyData.resetPartnerLinkCache();
                            this.m_authPropertyData.setDirty();
                            this.m_tempEndPoint = null;
                            this.m_tempPortType = null;
                            this.m_tempRole = null;
                            this.m_tempProcessPortType = null;
                            this.m_tempProcessRole = null;
                            this.fireTableRowsInserted(nRowIndex + 1, nRowIndex + 1);
                            this.m_changedItems = new Vector();
                            this.m_changedItems.addElement(partnerLink);
                            this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 526);
                        }
                    }
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_authPropertyData == null) break block9;
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateEndPoint(int nRowIndex, Object aValue) {
        try {
            block8: {
                try {
                    VWPartnerLinkDefinition partnerLinkDef = null;
                    String endPoint = (String)aValue;
                    VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                    if (wrapper != null) {
                        partnerLinkDef = (VWPartnerLinkDefinition)wrapper.getValue();
                    }
                    if (partnerLinkDef != null) {
                        if (VWStringUtils.compare(partnerLinkDef.getPartnerEndPoint(), endPoint) != 0) {
                            partnerLinkDef.setPartnerEndPoint(endPoint);
                            this.m_authPropertyData.setDirty();
                            this.updateInvokeInstructions(partnerLinkDef);
                            this.m_changedItems = new Vector();
                            this.m_changedItems.addElement(partnerLinkDef);
                            this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 529);
                        }
                        break block8;
                    }
                    this.m_tempEndPoint = endPoint;
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    if (this.m_authPropertyData != null) {
                        VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
                    }
                    Object var7_8 = null;
                    this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                    return;
                }
            }
            Object var7_7 = null;
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
            return;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updatePortType(int nRowIndex, Object aValue) {
        try {
            try {
                VWPartnerLinkDefinition partnerLink = null;
                String portType = (String)aValue;
                VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                if (wrapper != null) {
                    partnerLink = (VWPartnerLinkDefinition)wrapper.getValue();
                }
                if (partnerLink != null) {
                    partnerLink.setPartnerPortType(portType);
                    this.m_authPropertyData.setDirty();
                    this.m_changedItems = new Vector();
                    this.m_changedItems.addElement(partnerLink);
                    this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 529);
                }
                this.m_tempPortType = portType;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_authPropertyData != null) {
                    VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
                }
                Object var7_8 = null;
                this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                return;
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
            throw throwable;
        }
        this.fireTableRowsUpdated(nRowIndex, nRowIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateRole(int nRowIndex, Object aValue) {
        try {
            try {
                VWPartnerLinkDefinition partnerLink = null;
                String role = (String)aValue;
                VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                if (wrapper != null) {
                    partnerLink = (VWPartnerLinkDefinition)wrapper.getValue();
                }
                if (partnerLink != null) {
                    partnerLink.setPartnerRole(role);
                    this.m_authPropertyData.setDirty();
                    this.m_changedItems = new Vector();
                    this.m_changedItems.addElement(partnerLink);
                    this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 529);
                }
                this.m_tempRole = role;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_authPropertyData != null) {
                    VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
                }
                Object var7_8 = null;
                this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                return;
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
            throw throwable;
        }
        this.fireTableRowsUpdated(nRowIndex, nRowIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateProcessPortType(int nRowIndex, Object aValue) {
        try {
            try {
                VWPartnerLinkDefinition partnerLink = null;
                String processPortType = (String)aValue;
                VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                if (wrapper != null) {
                    partnerLink = (VWPartnerLinkDefinition)wrapper.getValue();
                }
                if (partnerLink != null) {
                    partnerLink.setMyPortType(processPortType);
                    this.m_authPropertyData.setDirty();
                    this.m_changedItems = new Vector();
                    this.m_changedItems.addElement(partnerLink);
                    this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 529);
                }
                this.m_tempProcessPortType = processPortType;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_authPropertyData != null) {
                    VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
                }
                Object var7_8 = null;
                this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                return;
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
            throw throwable;
        }
        this.fireTableRowsUpdated(nRowIndex, nRowIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateProcessRole(int nRowIndex, Object aValue) {
        try {
            try {
                VWPartnerLinkDefinition partnerLink = null;
                String processRole = (String)aValue;
                VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                if (wrapper != null) {
                    partnerLink = (VWPartnerLinkDefinition)wrapper.getValue();
                }
                if (partnerLink != null) {
                    partnerLink.setMyRole(processRole);
                    this.m_authPropertyData.setDirty();
                    this.m_changedItems = new Vector();
                    this.m_changedItems.addElement(partnerLink);
                    this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 529);
                }
                this.m_tempProcessRole = processRole;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_authPropertyData != null) {
                    VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
                }
                Object var7_8 = null;
                this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                return;
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
            throw throwable;
        }
        this.fireTableRowsUpdated(nRowIndex, nRowIndex);
    }

    private void updateInvokeInstructions(VWPartnerLinkDefinition partnerLinkDef) {
        try {
            String[] portTypes;
            if (partnerLinkDef == null) {
                return;
            }
            String currentPortType = partnerLinkDef.getPartnerPortType();
            if (currentPortType == null || currentPortType.length() == 0) {
                return;
            }
            boolean bFoundPortType = false;
            VWWebServiceUtils wsUtils = this.m_authPropertyData.getWebServiceUtils();
            if (wsUtils != null && (portTypes = wsUtils.getPortTypes(new WSWSDLRefs(partnerLinkDef.getPartnerEndPoint(), partnerLinkDef.getWSDLRef()).toString(), this.m_uiContainer)) != null && portTypes.length > 0) {
                for (int i = 0; i < portTypes.length; ++i) {
                    if (VWStringUtils.compare(currentPortType, portTypes[i]) != 0) continue;
                    bFoundPortType = true;
                    break;
                }
            }
            if (!bFoundPortType) {
                partnerLinkDef.setPartnerPortType(null);
            }
            WSOperation[] wsOperations = wsUtils.getOperationsFromPartnerLink(partnerLinkDef, false);
            VWMapDefinition[] mapDefs = this.m_authPropertyData.getMapCache().getCurrentMapDefinitions();
            if (mapDefs != null && mapDefs.length > 0) {
                for (int nMapIndex = 0; nMapIndex < mapDefs.length; ++nMapIndex) {
                    VWMapNode[] mapNodes = mapDefs[nMapIndex].getSteps();
                    if (mapNodes == null || mapNodes.length <= 0) continue;
                    for (int nMapNodeIndex = 0; nMapNodeIndex < mapNodes.length; ++nMapNodeIndex) {
                        VWInstructionDefinition[] instructionDefs;
                        if (!(mapNodes[nMapNodeIndex] instanceof VWCompoundStepDefinition) || (instructionDefs = ((VWCompoundStepDefinition)mapNodes[nMapNodeIndex]).getInstructions()) == null || instructionDefs.length <= 0) continue;
                        for (int nInstructionIndex = 0; nInstructionIndex < instructionDefs.length; ++nInstructionIndex) {
                            String operationName;
                            VWInvokeInstruction invokeInst;
                            if (instructionDefs[nInstructionIndex].getAction() != 39 || VWStringUtils.compare((invokeInst = (VWInvokeInstruction)instructionDefs[nInstructionIndex]).getPartnerLinkName(), partnerLinkDef.getName()) != 0 || (operationName = invokeInst.getOperationName()) == null) continue;
                            WSOperation wsOperation = null;
                            if (wsOperations != null) {
                                for (int i = 0; i < wsOperations.length; ++i) {
                                    if (VWStringUtils.compare(operationName, wsOperations[i].getDisplayName()) != 0) continue;
                                    wsOperation = wsOperations[i];
                                    break;
                                }
                            }
                            wsUtils.updateInvokeInstruction(wsOperation, invokeInst);
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public String getWSDLRef(int nRowIndex) {
        try {
            VWPartnerLinkDefinition partnerLink = null;
            VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
            if (wrapper != null) {
                partnerLink = (VWPartnerLinkDefinition)wrapper.getValue();
            }
            if (partnerLink != null) {
                return partnerLink.getWSDLRef();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }
}

